# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit gnome2-utils meson xdg

DESCRIPTION="This is a library for making it easier to generate valid DNG files following the Adobe Digital Negative specification."
HOMEPAGE="https://gitlab.com/megapixels-org/libdng"
SRC_URI="https://gitlab.com/megapixels-org/libdng/-/archive/${PV}/${P}.tar.gz"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="~arm64"

DEPEND="
	dev-libs/libconfig
	app-text/scdoc
	>=media-libs/tiff-4.0.0
"

RDEPEND="${DEPEND}"
BDEPEND=""

src_configure() {
	meson_src_configure
}

pkg_postinst() {
	xdg_pkg_postinst
	gnome2_schemas_update
}

pkg_postrm() {
	xdg_pkg_postrm
	gnome2_schemas_update
}
