# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit gnome2-utils meson xdg

DESCRIPTION="A GTK3 camera application that knows how to deal with the media request api"
HOMEPAGE="https://gitlab.com/megapixels-org/Megapixels"
SRC_URI="https://gitlab.com/megapixels-org/Megapixels/-/archive/2.0.0/Megapixels-2.0.0.tar.gz"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="~arm64"

DEPEND="
	gui-libs/gtk
	x11-libs/gtk+:3
	media-libs/tiff
	media-gfx/zbar
	media-libs/libepoxy
	media-libs/libraw
	media-gfx/dcraw
	media-gfx/imagemagick
	media-gfx/argyllcms
	dev-libs/feedbackd
	>=media-libs/libmegapixels-0.2.0
	>=media-libs/libdng-0.2.2
"

RDEPEND="${DEPEND}"
BDEPEND=""

S="${WORKDIR}/Megapixels-2.0.0"

src_configure() {
	meson_src_configure
}

pkg_postinst() {
	xdg_pkg_postinst
	gnome2_schemas_update
}

pkg_postrm() {
	xdg_pkg_postrm
	gnome2_schemas_update
}
