# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License-2

EAPI=8
inherit gnome2-utils meson

LCB_COMMIT="c13213ee71a189f4bc74d5754c645bc12bf52c01"
LVC_COMMIT="5f9768a2eac29c1ed56f1fbb449a77a3523683b6"
GVDB_COMMIT="4758f6fb7f889e074e13df3f914328f3eecb1fd3"
DESCRIPTION="A settings app for mobile specific things"
HOMEPAGE="https://gitlab.gnome.org/World/Phosh/phosh-mobile-settings"
SRC_URI="
	https://gitlab.gnome.org/World/Phosh/phosh-mobile-settings/-/archive/v${PV}/phosh-mobile-settings-v${PV}.tar.gz -> ${P}.tar.gz
	https://gitlab.gnome.org/GNOME/libgnome-volume-control/-/archive/${LVC_COMMIT}/libgnome-volume-control-${LVC_COMMIT}.tar.gz
	https://gitlab.freedesktop.org/devrtz/cellbroadcastd/-/archive/${LCB_COMMIT}/cellbroadcastd-${LCB_COMMIT}.tar.gz
	https://gitlab.gnome.org/GNOME/libgnome-volume-control/-/archive/${LVC_COMMIT}/libgnome-volume-control-${LVC_COMMIT}.tar.gz
	https://gitlab.gnome.org/GNOME/gvdb/-/archive/${GVDB_COMMIT}/gvdb-${GVDB_COMMIT}.tar.gz
	"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="~arm ~arm64"

RDEPEND="
	x11-wm/phoc
	gui-wm/phosh
	gui-libs/libadwaita
	>=dev-libs/gmobile-0.4.0
	sys-apps/lm-sensors
	>=dev-libs/feedbackd-0.7.0
"

BDEPEND="
"

S="${WORKDIR}/${PN}-v${PV}"

src_prepare() {
	default
	rm -r "${S}"/subprojects/gvc.wrap || die
	mv "${WORKDIR}"/libgnome-volume-control-"${LVC_COMMIT}" "${S}"/subprojects/gvc || die
	rm -r "${S}"/subprojects/libcellbroadcast.wrap || die
	mv "${WORKDIR}"/cellbroadcastd-"${LCB_COMMIT}" "${S}"/subprojects/libcellbroadcast || die		
	rm -r "${S}"/subprojects/libcellbroadcast/subprojects/gvdb.wrap || die
	mv "${WORKDIR}"/gvdb-"${GVDB_COMMIT}" "${S}"/subprojects/libcellbroadcast/subprojects/gvdb || die		

}

src_install() {
	CC="$(tc-getCC)"
	meson_src_install
}

pkg_postinst() {
	gnome2_schemas_update
	xdg_icon_cache_update
}

pkg_postrm() {
	gnome2_schemas_update
	xdg_icon_cache_update
}
