# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit meson xdg gnome2-utils

MY_PV="v${PV}"
MY_P="${PN}-${MY_PV}"

DESCRIPTION="Stevia is a on screen keyboard for Phosh."
HOMEPAGE="https://gitlab.gnome.org/World/Phosh/stevia"

SRC_URI="
	https://gitlab.gnome.org/World/Phosh/stevia/-/archive/${MY_PV}/${MY_P}.tar.gz
"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="~amd64 ~arm64"
IUSE="+introspection +systemd test"
RESTRICT="!test? ( test )"

RDEPEND="
	x11-wm/phoc
"

BDEPEND="
	dev-build/meson
	virtual/pkgconfig
"

S="${WORKDIR}/${MY_P}"


src_configure() {
	meson_src_configure
}

pkg_postinst() {
	xdg_pkg_postinst
	gnome2_schemas_update
}

pkg_postrm() {
	xdg_pkg_postrm
}
